import { __ } from '@wordpress/i18n';
import { useBlockProps, InspectorControls } from '@wordpress/block-editor';
import { PanelBody, TextControl, SelectControl } from '@wordpress/components';
import { useSelect } from '@wordpress/data';
import './editor.scss';

export default function Edit( { attributes, setAttributes } ) {
	const {
		headingText,
		seeAllText,
		queryType,
		category
	} = attributes;

	const categories = useSelect((select) => {
		const records = select('core').getEntityRecords('taxonomy', 'category', {
			per_page: -1,
		});
		return records
			? [
				{ label: __('Select a Category...'), value: '' },
				...records.map((cat) => ({
					label: cat.name,
					value: cat.id,
				})),
			  ]
			: [];
	}, []);

	return (
		<>
			<div { ...useBlockProps() }>
				{ __( 'Embla Carousel block.', 'embla-carousel' ) }
			</div>

			<InspectorControls>
				<PanelBody title={ __('Slider Settings', 'embla-carousel') }>
					<TextControl
						label={ __('Heading Text', 'embla-carousel') }
						value={ headingText }
						onChange={ (value) =>
							setAttributes( { headingText: value } )
						}
					/>
					<TextControl
						label={ __('See All Text', 'embla-carousel') }
						value={ seeAllText }
						onChange={ (value) =>
							setAttributes( { seeAllText: value } )
						}
					/>
					<SelectControl
						label={ __('Content Source', 'embla-carousel') }
						value={ queryType }
						options={ [
							{ label: __('Latest Posts', 'embla-carousel'), value: 'latest' },
							{ label: __('From a Category', 'embla-carousel'), value: 'category' }
						] }
						onChange={ (value) =>
							setAttributes( { queryType: value } )
						}
					/>
					{ queryType === 'category' && (
						<SelectControl
							label={ __('Category', 'embla-carousel') }
							value={ category }
							options={ categories }
							onChange={ (value) =>
								setAttributes( { category: value } )
							}
						/>
					) }
				</PanelBody>
			</InspectorControls>
		</>
	);
}