<?php
/**
 * Open Graph Meta Tags
 *
 * @package Sting
 */
if ( ! function_exists( 'open_graph_meta_tags' ) ) :
    function open_graph_meta_tags() {
        $home_url = home_url();

        echo "<!-- Open Graph Metadata optimized by {$home_url} -->\n";

        $tagline = 'Watch online in full HD quality with fast streaming, subtitles support, multiple servers, and compatible across all devices.';
        $description = is_single()
            ? ( get_the_excerpt() ? get_the_excerpt() : get_the_title() . ' - ' . $tagline )
            : get_bloginfo( 'description' );

        echo '<meta name="description" content="' . esc_attr( $description ) . '" />' . "\n";
        
        echo '<meta property="og:locale" content="' . esc_attr( get_locale() ) . '" />' . "\n";

        echo '<meta property="og:type" content="' . ( is_singular() ? 'article' : 'website' ) . '" />' . "\n";

        $title = is_singular() ? get_the_title() : get_bloginfo( 'name' );
        echo '<meta property="og:title" content="' . esc_attr( $title ) . '" />' . "\n";

        echo '<meta property="og:site_name" content="' . esc_attr( get_bloginfo( 'name' ) ) . '" />' . "\n";

        echo '<meta property="og:description" content="' . esc_attr( $description ) . '" />' . "\n";

        global $wp;
        $url = is_singular() ? get_permalink() : home_url( add_query_arg( array(), $wp->request ) );
        echo '<meta property="og:url" content="' . esc_url( $url ) . '" />' . "\n";

        if ( is_singular() && has_post_thumbnail() ) {
            $thumbnail_id = get_post_thumbnail_id();
            $thumbnail    = wp_get_attachment_image_src( $thumbnail_id, 'full' );

            if ( $thumbnail ) {
                echo '<meta property="og:image" content="' . esc_url( $thumbnail[0] ) . '" />' . "\n";
            }
        } else {
            $default_image = get_option( 'og_image_url' );
            echo '<meta property="og:image" content="' . esc_url( $default_image ) . '" />' . "\n";
        }

        echo '<meta property="og:image:width" content="1200" />' . "\n";

        echo '<meta property="og:image:height" content="630" />' . "\n";

        echo '<meta name="twitter:card" content="summary_large_image" />' . "\n";

        if ( is_front_page() || is_home() ) {
            $site_name       = get_bloginfo( 'name' );
            $site_url        = home_url( '/' );
            $homepage_schema = array(
                '@context'        => 'http://schema.org',
                '@type'           => 'WebSite',
                'name'            => $site_name,
                'url'             => $site_url,
                'potentialAction' => array(
                    '@type'       => 'SearchAction',
                    'target'      => $site_url . '?s={search_term_string}',
                    'query-input' => 'required name=search_term_string',
                ),
            );

            echo '<script type="application/ld+json" id="json-schema">' . wp_json_encode( $homepage_schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE ) . '</script>' . "\n";
        }

        if ( is_singular() ) {
            $post = get_post();

            if ( has_post_thumbnail( $post->ID ) ) {
                $images = array(
                    get_the_post_thumbnail_url( $post->ID, 'thumbnail' ),
                    get_the_post_thumbnail_url( $post->ID, 'medium' ),
                    get_the_post_thumbnail_url( $post->ID, 'large' ),
                );
            } else {
                $images = array();
            }

            $news_schema = array(
                '@type'             => 'NewsArticle',
                'headline'          => get_the_title( $post ),
                'description'       => get_the_excerpt( $post ),
                'image'             => $images,
                'author'            => array(
                    '@type' => 'Person',
                    'name'  => get_the_author_meta( 'display_name', $post->post_author ),
                    'url'   => get_author_posts_url( $post->post_author ),
                ),
                'datePublished'     => get_the_date( 'c', $post ),
                'dateModified'      => get_the_modified_date( 'c', $post ),
                'mainEntityOfPage'  => array(
                    '@type' => 'WebPage',
                    '@id'   => get_permalink( $post ),
                ),
            );

            $breadcrumb_schema = array(
                '@type'           => 'BreadcrumbList',
                'itemListElement' => array(
                    array(
                        '@type'    => 'ListItem',
                        'position' => 1,
                        'name'     => 'Home',
                        'item'     => home_url( '/' ),
                    ),
                    array(
                        '@type'    => 'ListItem',
                        'position' => 2,
                        'name'     => get_the_title( $post ),
                        'item'     => get_permalink( $post ),
                    ),
                ),
            );

            $full_schema = array(
                '@context' => 'https://schema.org',
                '@graph'   => array(
                    $news_schema,
                    $breadcrumb_schema,
                ),
            );

            echo '<script type="application/ld+json" id="json-schema">' . wp_json_encode( $full_schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE ) . '</script>' . "\n";
        }

        echo "<!-- / End Open Graph Metadata -->\n";
    }
endif;
add_action( 'wp_head', 'open_graph_meta_tags', 1 );