<?php
/**
 * Block Bindings
 *
 * @package Sting
 */
if ( ! function_exists( 'sting_block_bindings_filter' ) ) :
    function sting_block_bindings_filter( $value, $name, $args ) {
        if ( $name !== 'core/post-meta' ) {
            return $value;
        }

        if ( isset( $args['key'] ) && $args['key'] === 'episode_or_runtime' ) {
            $episode = intval( $value );
            return 'Total ' . $episode;
        }

        if ( isset( $args['key'] ) && $args['key'] === 'release_status' ) {
            $post_id = get_the_ID();
            $episode_num = get_post_meta( $post_id, 'episode_or_runtime', true );
            $ep_int = intval( $episode_num );
            $has_episodes = ( ! empty( $episode_num ) && $ep_int > 0 );

            if ( ! $has_episodes ) {
                return 'upcoming';
            }

            if ( $value === 'completed' && $has_episodes ) {
                return 'completed';
            }

            return 'ongoing';
        }

        return $value;
    }
endif;
add_filter( 'block_bindings_source_value', 'sting_block_bindings_filter', 10, 3 );