<?php
/*
 * Admin Settings
 *
 * @package Sting
 */
if ( ! function_exists( 'sting_admin_settings' ) ) :
    function sting_admin_settings() {
        add_menu_page(
            'Sting Settings',
            'Sting',
            'manage_options',
            'sting-settings',
            'sting_settings_page',
            'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0Ij48cGF0aCBmaWxsPSJjdXJyZW50Q29sb3IiIGQ9Ik0xMiAxNS41QTMuNSAzLjUgMCAwIDEgOC41IDEyQTMuNSAzLjUgMCAwIDEgMTIgOC41YTMuNSAzLjUgMCAwIDEgMy41IDMuNWEzLjUgMy41IDAgMCAxLTMuNSAzLjVtNy40My0yLjUzYy4wNC0uMzIuMDctLjY0LjA3LS45N3MtLjAzLS42Ni0uMDctMWwyLjExLTEuNjNjLjE5LS4xNS4yNC0uNDIuMTItLjY0bC0yLTMuNDZjLS4xMi0uMjItLjM5LS4zMS0uNjEtLjIybC0yLjQ5IDFjLS41Mi0uMzktMS4wNi0uNzMtMS42OS0uOThsLS4zNy0yLjY1QS41MDYuNTA2IDAgMCAwIDE0IDJoLTRjLS4yNSAwLS40Ni4xOC0uNS40MmwtLjM3IDIuNjVjLS42My4yNS0xLjE3LjU5LTEuNjkuOThsLTIuNDktMWMtLjIyLS4wOS0uNDkgMC0uNjEuMjJsLTIgMy40NmMtLjEzLjIyLS4wNy40OS4xMi42NEw0LjU3IDExYy0uMDQuMzQtLjA3LjY3LS4wNyAxcy4wMy42NS4wNy45N2wtMi4xMSAxLjY2Yy0uMTkuMTUtLjI1LjQyLS4xMi42NGwyIDMuNDZjLjEyLjIyLjM5LjMuNjEuMjJsMi40OS0xLjAxYy41Mi40IDEuMDYuNzQgMS42OS45OWwuMzcgMi42NWMuMDQuMjQuMjUuNDIuNS40Mmg0Yy4yNSAwIC40Ni0uMTguNS0uNDJsLjM3LTIuNjVjLjYzLS4yNiAxLjE3LS41OSAxLjY5LS45OWwyLjQ5IDEuMDFjLjIyLjA4LjQ5IDAgLjYxLS4yMmwyLTMuNDZjLjEyLS4yMi4wNy0uNDktLjEyLS42NHoiLz48L3N2Zz4=',
            60
        );
    }
endif;
add_action( 'admin_menu', 'sting_admin_settings' );

// Settings page
function sting_settings_page() {
    ?>
    <div class="wrap">
        <h1>Sting Settings</h1>

        <?php
        if ( isset( $_GET['settings-updated'] ) && $_GET['settings-updated'] ) {
            add_settings_error( 'sting_messages', 'sting_message', 'Settings Saved', 'updated' );
        }
        settings_errors( 'sting_messages' );
        ?>

        <form method="post" action="options.php">
            <?php
            settings_fields( 'sting_settings_group' );
            do_settings_sections( 'sting-settings' );
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

// Register section and fields
function register_sting_settings() {
    register_setting(
        'sting_settings_group',
        'og_image_url',
        array(
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    register_setting(
        'sting_settings_group',
        'adsterra_popunder',
        array(
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    register_setting(
        'sting_settings_group',
        'video_playlist_license_key',
        array(
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    register_setting(
        'sting_settings_group',
        'video_player_div_id',
        array(
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    register_setting(
        'sting_settings_group',
        'blogger_ids',
        array(
            'sanitize_callback' => 'sanitize_blogger_ids',
        )
    );

    add_settings_section(
        'sting_settings_section',
        null,
        null,
        'sting-settings'
    );

    add_settings_field(
        'og_image_url',
        'Default OG Image URL',
        'render_og_image_url_field',
        'sting-settings',
        'sting_settings_section'
    );

    add_settings_field(
        'adsterra_popunder',
        'Adsterra Popunder',
        'render_adsterra_popunder_field',
        'sting-settings',
        'sting_settings_section'
    );

    add_settings_field(
        'video_playlist_license_key',
        'Video Playlist License Key',
        'render_license_key_field',
        'sting-settings',
        'sting_settings_section'
    );

    add_settings_field(
        'video_player_div_id',
        'Player Container ID',
        'render_player_div_field',
        'sting-settings',
        'sting_settings_section'
    );

    add_settings_field(
        'blogger_ids',
        'API: Blogger ID(s)',
        'render_blogger_ids_field',
        'sting-settings',
        'sting_settings_section'
    );
}
add_action( 'admin_init', 'register_sting_settings' );

// OG Image URL input field
function render_og_image_url_field() {
    $og_image_url = get_option( 'og_image_url' );
    ?>
    <input 
        type="url" 
        name="og_image_url" 
        value="<?php echo esc_attr( $og_image_url ); ?>" 
        class="regular-text code" 
        placeholder="https://example.com/image/og-image.png"
    >
    <p class="description">Recommended image size: 1200 x 630 pixels.</p>
    <?php
}

// Adsterra popunder URL input field
function render_adsterra_popunder_field() {
    $url = get_option( 'adsterra_popunder' );
    ?>
    <input 
        type="url" 
        name="adsterra_popunder" 
        value="<?php echo esc_attr( $url ); ?>" 
        class="regular-text code" 
        placeholder="https://example.com/popunder.js"
    >
    <p class="description">Adsterra popunder script URL.</p>
    <?php
}

// license key input field
function render_license_key_field() {
    $license_key = get_option( 'video_playlist_license_key' );
    ?>
    <input 
        type="text" 
        name="video_playlist_license_key" 
        value="<?php echo esc_attr( $license_key ); ?>" 
        class="regular-text code" 
        placeholder="XXXXXXXXXXXXXXXXXXXX"
    >
    <p class="description">Enter your license key.</p>
    <?php
}

// Player div ID input field
function render_player_div_field() {
    $player_div_id = get_option( 'video_player_div_id' );
    ?>
    <input 
        type="text" 
        name="video_player_div_id" 
        value="<?php echo esc_attr( $player_div_id ); ?>" 
        class="regular-text code" 
        placeholder="abc-player"
    >
    <p class="description">This ID will be used to render the video player.</p>
    <?php
}

// Blogger IDs textarea field
function render_blogger_ids_field() {
    $blogger_ids = get_option( 'blogger_ids' );
    ?>
    <textarea 
        name="blogger_ids" 
        rows="5" 
        cols="50" 
        class="large-text code" 
        placeholder="01234567890123456789"
    ><?php echo esc_textarea( $blogger_ids ); ?></textarea>
    <p class="description">Enter one Blogger ID per line.</p>
    <?php
}

// Sanitize blogger IDs
function sanitize_blogger_ids( $input ) {
    if ( empty( $input ) ) {
        return '';
    }

    $ids = explode( "\n", $input );
    $sanitized_ids = array();
    
    foreach ( $ids as $id ) {
        $clean_id = sanitize_text_field( trim( $id ) );
        if ( ! empty( $clean_id ) ) {
            $sanitized_ids[] = $clean_id;
        }
    }
    
    return implode( "\n", $sanitized_ids );
}