<?php
// Adds theme support for post formats
if ( ! function_exists( 'sting_post_format_setup' ) ) :
	function sting_post_format_setup() {
		add_theme_support( 'post-formats', array( 'aside', 'audio', 'chat', 'gallery', 'image', 'link', 'quote', 'status', 'video' ) );
	}
endif;
add_action( 'after_setup_theme', 'sting_post_format_setup' );

// Enqueues editor-style.css in the editors
if ( ! function_exists( 'sting_editor_style' ) ) :
	function sting_editor_style() {
		add_editor_style( get_parent_theme_file_uri( 'assets/css/editor-style.css' ) );
	}
endif;
add_action( 'after_setup_theme', 'sting_editor_style' );

// Enqueues CSS
if ( ! function_exists( 'sting_enqueue_styles' ) ) :
	function sting_enqueue_styles() {
		$suffix = SCRIPT_DEBUG ? '' : '.min';
		$src    = 'style' . $suffix . '.css';

		wp_enqueue_style(
			'sting',
			get_parent_theme_file_uri( $src ),
			array(),
			wp_get_theme()->get( 'Version' )
		);
		wp_style_add_data(
			'sting',
			'path',
			get_parent_theme_file_path( $src )
		);
	}
endif;
add_action( 'wp_enqueue_scripts', 'sting_enqueue_styles' );

// Enqueues JS
if ( ! function_exists( 'sting_enqueue_scripts' ) ) :
	function sting_enqueue_scripts() {
		$adsterra_popunder_url = get_option( 'adsterra_popunder' );
		if ( $adsterra_popunder_url ) {
			wp_enqueue_script(
				'adsterra-popunder',
				esc_url( $adsterra_popunder_url ),
				array(),
				null,
				false
			);
		};
		if ( is_home() && ! is_paged() ) {
			wp_enqueue_script(
                'embla-carousel',
                'https://unpkg.com/embla-carousel/embla-carousel.umd.js',
                array(),
                null,
                true
            );
			wp_enqueue_script(
				'embla-carousel-init',
				get_template_directory_uri() . '/assets/js/embla-carousel-init.min.js',
				array(),
				null,
				true
			);
		};
		$license_key = get_option( 'video_playlist_license_key' );
		if ( is_singular() && $license_key ) {
            wp_enqueue_script(
                'crypto',
                get_template_directory_uri() . '/assets/js/crypto-js.min.js',
                array(),
                '4.2.0',
                true
            );
            wp_enqueue_script(
				'jwplayer',
				'https://content.jwplatform.com/libraries/IDzF9Zmk.js',
				array(),
				null,
				true
            );
			wp_enqueue_script(
                'playlist',
                get_template_directory_uri() . '/assets/js/playlist.min.js',
                array(),
                null,
                true
            );
			$logo_url = '';
			if ( has_custom_logo() ) {
				$custom_logo_id = get_theme_mod( 'custom_logo' );
				$logo_url = wp_get_attachment_image_url( $custom_logo_id, 'full' );
			}
			$video_player_settings = [
				'license' => $license_key,
				'playerContainer' => get_option( 'video_player_div_id' ),
				'jwplayerLogo' => $logo_url,
				'bloggerAPI' => [
					'blogId' => array_filter(explode("\n", get_option('blogger_ids', ''))),
				],
			];
			$player_options = 'const videoPlayerSettings = ' . wp_json_encode($video_player_settings, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE ) . ';';
			wp_add_inline_script( 'playlist', $player_options, 'before' );
		}
	}
endif;
add_action( 'wp_enqueue_scripts', 'sting_enqueue_scripts' );

// Initialization
require_once get_template_directory() . '/inc/theme-init.php';