import { __ } from '@wordpress/i18n';
import { useBlockProps, InspectorControls } from '@wordpress/block-editor';
import { PanelBody, TextControl, TextareaControl } from '@wordpress/components';
import './editor.scss';

export default function Edit( { attributes, setAttributes } ) {
	const { description, buttonText, buttonUrl } = attributes;

	return (
		<>
			<div { ...useBlockProps() }>
				{ __( 'Telegram Card block.', 'telegram-card' ) }
			</div>

			<InspectorControls>
				<PanelBody title={ __( 'Telegram Card Settings', 'telegram-card' ) }>
					<TextareaControl
						label={ __( 'Description', 'telegram-card' ) }
						value={ description }
						onChange={ ( value ) =>
							setAttributes( { description: value } )
						}
					/>
					<TextControl
						label={ __( 'Button Text', 'telegram-card' ) }
						value={ buttonText }
						onChange={ ( value ) =>
							setAttributes( { buttonText: value } )
						}
					/>
					<TextControl
						label={ __( 'Button URL', 'telegram-card' ) }
						value={ buttonUrl }
						onChange={ ( value ) =>
							setAttributes( { buttonUrl: value } )
						}
						type="url"
					/>
				</PanelBody>
			</InspectorControls>
		</>
	);
}