import { __ } from '@wordpress/i18n';
import { useBlockProps, InspectorControls } from '@wordpress/block-editor';
import { PanelBody, TextControl, RangeControl } from '@wordpress/components';
import './editor.scss';

export default function Edit( { attributes, setAttributes } ) {
	const { headingText, postsToShow } = attributes;
	
	return (
		<>
			<div { ...useBlockProps() }>
				{ __( 'Related Posts block.', 'related-posts' ) }
			</div>

			<InspectorControls>
				<PanelBody title={ __('Related Posts Settings', 'related-posts') }>
					<TextControl
						label={ __('Heading Text', 'related-posts') }
						value={ headingText }
						onChange={ (value) =>
							setAttributes( { headingText: value } )
						}
					/>
					<RangeControl
						label={ __('Number of posts', 'related-posts') }
						value={ postsToShow }
						onChange={ (value) =>
							setAttributes( { postsToShow: value } )
						}
						min={ 12 }
						max={ 18 }
					/>
				</PanelBody>
			</InspectorControls>
		</>
	);
}