<?php
/**
 * Register Post Meta
 *
 * @package Spring
 */
if ( ! function_exists( 'spring_register_post_meta' ) ) :
    function spring_register_post_meta() {
        register_post_meta( 'post', 'episode_number', array(
            'show_in_rest' => true,
            'single' => true,
            'type' => 'string',
            'auth_callback' => function() {
                return current_user_can('edit_posts');
            }
        ) );

        register_post_meta( 'post', 'release_status', array(
            'show_in_rest' => true,
            'single' => true,
            'type' => 'string',
            'auth_callback' => function() {
                return current_user_can('edit_posts');
            }
        ) );

        register_post_meta( 'post', 'movie_quality', array(
            'show_in_rest' => true,
            'single' => true,
            'type' => 'string',
            'auth_callback' => function() {
                return current_user_can('edit_posts');
            }
        ) );
    }
endif;
add_action( 'init', 'spring_register_post_meta' );