<?php
global $post;

$heading_text = isset( $attributes['headingText'] ) ? sanitize_text_field( $attributes['headingText'] ) : 'You may also like';
$posts_to_show = isset( $attributes['postsToShow'] ) ? absint( $attributes['postsToShow'] ) : 12;

$categories   = get_the_category( $post->ID );
$category_ids = array();

foreach ( $categories as $category ) {
    $category_ids[] = $category->term_id;
}

$args = array(
    'posts_per_page'      => $posts_to_show,
    'post__not_in'        => array( $post->ID ),
    'ignore_sticky_posts' => 1,
    'category__in'        => $category_ids,
    'orderby'             => 'date',
);

$related_posts = new WP_Query( $args );

if ( $related_posts->have_posts() ) :
    ?>
    <div class="related-posts-block">
        <h3 class="wp-block-heading heading-style"><?php echo esc_html( $heading_text ); ?></h3>
        <ul class="related-posts">
            <?php
            while ( $related_posts->have_posts() ) :
                $related_posts->the_post();
                $post_id = get_the_ID();
				$episode_number = get_post_meta( $post_id, 'episode_number', true );
				$movie_quality = get_post_meta( $post_id, 'movie_quality', true );
                ?>
                <li class="related-item">
                    <figure class="wp-block-post-featured-image">
                        <a href="<?php echo esc_url( get_permalink() ); ?>" target="_self">
                            <?php
                            if ( has_post_thumbnail() ) {
                                echo get_the_post_thumbnail(
                                    get_the_ID(),
                                    'large',
                                    array(
                                        'alt' => esc_attr( get_the_title() ? get_the_title() : 'No title' ),
                                    )
                                );
                            } else {
                                echo '<img src="' . esc_url( get_template_directory_uri() . '/assets/images/blank.gif' ) . '" alt="' . esc_attr( get_the_title() ? get_the_title() : 'No title' ) . '">';
                            }
                            ?>
                            <?php if ( ! empty( $episode_number ) ) : ?>
								<span class="episode">EP.<?php echo esc_html( $episode_number ); ?></span>
							<?php endif; ?>
							<?php if ( ! empty( $movie_quality ) ) : ?>
								<span class="video-quality"><?php echo esc_html( strtoupper( $movie_quality ) ); ?></span>
							<?php endif; ?>
                        </a>
                    </figure>
                    <div class="entry-header">
                        <h2 class="wp-block-post-title">
                            <a href="<?php echo esc_url( get_permalink() ); ?>" target="_self"><?php echo esc_html( get_the_title() ? get_the_title() : 'No title' ); ?></a>
                        </h2>
                    </div>
                </li>
            <?php endwhile; ?>
        </ul>
    </div>
    <?php
    wp_reset_postdata();
endif;
?>