<?php
/**
 * Block Filters
 * 
 * @package Spring
 */
if ( ! function_exists( 'embla_carousel_block_filter' ) ) :
    function embla_carousel_block_filter( $block_content, $block ) {
        $has_class = isset( $block['attrs']['className'] ) 
                        && strpos( $block['attrs']['className'], 'embla-carousel-block' ) !== false;

        if ( $has_class && ( ! is_home() || is_paged() ) ) {
            return '';
        }

        return $block_content;
    }
endif;
add_filter( 'render_block_core/group', 'embla_carousel_block_filter', 10, 2 );

// Add custom label to featured image block
if ( ! function_exists( 'add_custom_label_to_featured_image' ) ) :
    function add_custom_label_to_featured_image( $block_content, $block ) {
        $post_id = get_the_ID();
        $episode = get_post_meta( $post_id, 'episode_number', true );
        $movie_quality = get_post_meta( $post_id, 'movie_quality', true );

        if ( ! empty( $episode ) ) {
            $episode_label = '<span class="episode">EP.' . esc_html( $episode ) . '</span>';
            
            if ( strpos( $block_content, '</a>' ) !== false ) {
                $block_content = str_replace( '</a>', $episode_label . '</a>', $block_content );
            }
        }

        if ( ! empty( $movie_quality ) ) {
            $quality_label = '<span class="video-quality">' . esc_html( strtoupper( $movie_quality ) ) . '</span>';
            
            if ( strpos( $block_content, '</a>' ) !== false ) {
                $block_content = str_replace( '</a>', $quality_label . '</a>', $block_content );
            }
        }

        return $block_content;
    }
endif;
add_filter( 'render_block_core/post-featured-image', 'add_custom_label_to_featured_image', 10, 2 );

// Modify group block for metadata
if ( ! function_exists( 'modify_group_block_for_metadata' ) ) :
    function modify_group_block_for_metadata( $block_content, $block ) {
        if ( ! is_single() ) {
            return $block_content;
        }

        $has_class = isset( $block['attrs']['className'] ) 
                        && strpos( $block['attrs']['className'], 'drama-info' ) !== false;

        $episode_number = get_post_meta( get_the_ID(), 'episode_number', true );

        if ( $has_class && empty( $episode_number ) ) {
            return '';
        }

        return $block_content;
    }
endif;
add_filter( 'render_block_core/group', 'modify_group_block_for_metadata', 10, 2 );