<?php
$args = array(
	'post_type'           => 'post',
	'posts_per_page'      => $attributes['postsToShow'],
	'post_status'         => 'publish',
	'ignore_sticky_posts' => 1,
);

if ( 'category' === $attributes['queryType'] && ! empty( $attributes['category'] ) ) {
	$args['cat'] = $attributes['category'];
}

$recent_posts = new WP_Query( $args );

if ( ! $recent_posts->have_posts() ) {
	return '';
}

$heading_text = isset( $attributes['headingText'] ) ? $attributes['headingText'] : 'Recent Posts';
$see_all_text = isset( $attributes['seeAllText'] ) ? $attributes['seeAllText'] : 'See All';

$see_all_link = '';
if ( 'category' === $attributes['queryType'] && ! empty( $attributes['category'] ) ) {
	$category_link = get_category_link( intval( $attributes['category'] ) );
	$see_all_link = sprintf(
		'<a class="see-all" href="%s">%s</a>',
		esc_url( $category_link ),
		esc_html( $see_all_text )
	);
}
?>

<div class="embla-carousel">
	<div class="embla__header">
		<h3 class="wp-block-heading heading-style"><?php echo esc_html( $heading_text ); ?></h3>
		<div class="embla__controls">
			<?php echo $see_all_link; ?>
			<button class="embla__prev" aria-label="Previous slide">
				<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="currentColor" d="M15.41 7.41L14 6l-6 6l6 6l1.41-1.41L10.83 12z"/></svg>
			</button>
			<button class="embla__next" aria-label="Next slide">
				<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="currentColor" d="M10 6L8.59 7.41L13.17 12l-4.58 4.59L10 18l6-6z"/></svg>
			</button>
		</div>
	</div>
	<div class="embla__viewport">
		<div class="embla__container">
			<?php
			while ( $recent_posts->have_posts() ) :
				$recent_posts->the_post();
				$post_id = get_the_ID();
				$episode_number = get_post_meta( $post_id, 'episode_or_runtime', true );
				$movie_quality = get_post_meta( $post_id, 'movie_quality', true );
				?>
				<div class="embla__slide">
					<div class="embla__slide-card">
						<figure class="wp-block-post-featured-image">
							<a href="<?php echo esc_url( get_permalink() ); ?>" target="_self">
								<?php
								if ( has_post_thumbnail() ) {
									echo get_the_post_thumbnail(
										get_the_ID(),
										'large',
										array( 
											'alt' => esc_attr( get_the_title() ? get_the_title() : 'No title' ) 
										)
									);
								} else {
									echo '<img src="' . esc_url( get_template_directory_uri() . '/assets/images/blank.gif' ) . '" alt="' . esc_attr( get_the_title() ? get_the_title() : 'No title' ) . '">';
								}
								?>
								<?php if ( $episode_number && preg_match( '/^\d+$/', $episode_number ) ) : ?>
									<span class="episode">EP.<?php echo esc_html( $episode_number ); ?></span>
								<?php endif; ?>
								<?php if ( ! empty( $movie_quality ) ) : ?>
									<span class="video-quality"><?php echo esc_html( strtoupper( $movie_quality ) ); ?></span>
								<?php endif; ?>
							</a>
						</figure>
						<div class="entry-header">
							<h2 class="wp-block-post-title">
								<a href="<?php echo esc_url( get_permalink() ); ?>" target="_self"><?php echo esc_html( get_the_title() ? get_the_title() : 'No title' ); ?></a>
							</h2>
						</div>
					</div>
				</div>
				<?php
			endwhile;
			wp_reset_postdata();
			?>
		</div>
	</div>
</div>