<?php
/**
 * Plugin Initialization
 *
 * @package Snite
 */
if ( ! function_exists( 'snite_register_block' ) ) :
	function snite_register_block() {
		$build_dir     = get_template_directory() . '/inc/build';
		$manifest_file = $build_dir . '/blocks-manifest.php';

		if ( function_exists( 'wp_register_block_types_from_metadata_collection' ) ) {
			wp_register_block_types_from_metadata_collection( $build_dir, $manifest_file );
			return;
		}

		if ( function_exists( 'wp_register_block_metadata_collection' ) ) {
			wp_register_block_metadata_collection( $build_dir, $manifest_file );
		}

		$manifest_data = require $manifest_file;
		foreach ( array_keys( $manifest_data ) as $block_type ) {
			register_block_type( $build_dir . "/{$block_type}" );
		}
	}
endif;
add_action( 'init', 'snite_register_block' );

// Enqueue script for document setting panel
if ( ! function_exists( 'enqueue_plugin_document_setting_panel' ) ) :
	function enqueue_plugin_document_setting_panel() {
        if ( ! is_admin() ) {
			return;
		}

        $asset_file = get_template_directory() . '/inc/build/custom-label.asset.php';

        if ( file_exists( $asset_file ) ) {
			$asset = include $asset_file;
            wp_enqueue_script(
                'setting-panel-script',
                get_template_directory_uri() . '/inc/build/custom-label.js',
                $asset['dependencies'],
                $asset['version'],
                true
            );
		}
    }
endif;
add_action( 'enqueue_block_assets', 'enqueue_plugin_document_setting_panel' );