<?php
/**
 * Block Filters
 * 
 * @package Snite
 */
if ( ! function_exists( 'embla_carousel_block_filter' ) ) :
    function embla_carousel_block_filter( $block_content, $block ) {
        $has_class = isset( $block['attrs']['className'] ) 
                        && strpos( $block['attrs']['className'], 'embla-carousel-block' ) !== false;

        if ( $has_class && ( ! is_home() || is_paged() ) ) {
            return '';
        }

        return $block_content;
    }
endif;
add_filter( 'render_block_core/group', 'embla_carousel_block_filter', 10, 2 );

// Add custom label to featured image block
if ( ! function_exists( 'add_custom_label_to_featured_image' ) ) :
    function add_custom_label_to_featured_image( $block_content, $block ) {
        $post_id = get_the_ID();
        $episode = get_post_meta( $post_id, 'episode_or_runtime', true );
        $movie_quality = get_post_meta( $post_id, 'movie_quality', true );
        $has_class = isset( $block['attrs']['className'] ) 
                        && strpos( $block['attrs']['className'], 'post-backdrop' ) !== false;

        if ( ! empty( $episode ) && ! $has_class && preg_match( '/^\d+$/', $episode ) ) {
            $episode_label = '<span class="episode">EP.' . esc_html( $episode ) . '</span>';
            
            if ( strpos( $block_content, '</a>' ) !== false ) {
                $block_content = str_replace( '</a>', $episode_label . '</a>', $block_content );
            }
        }

        if ( ! empty( $movie_quality ) && ! $has_class ) {
            $quality_label = '<span class="video-quality">' . esc_html( strtoupper( $movie_quality ) ) . '</span>';
            
            if ( strpos( $block_content, '</a>' ) !== false ) {
                $block_content = str_replace( '</a>', $quality_label . '</a>', $block_content );
            }
        }

        return $block_content;
    }
endif;
add_filter( 'render_block_core/post-featured-image', 'add_custom_label_to_featured_image', 10, 2 );

// Modify paragraph block for metadata
if ( ! function_exists( 'modify_paragraph_block_for_metadata' ) ) :
    function modify_paragraph_block_for_metadata( $block_content, $block ) {
        if ( ! is_single() ) {
            return $block_content;
        }

        $class = $block['attrs']['className'] ?? '';

        $is_episode_label = strpos( $class, 'episode-label' ) !== false;
        $is_total_episode = strpos( $class, 'total-episode' ) !== false;
        $is_release_year = strpos( $class, 'release-year' ) !== false;
        $is_release_status = strpos( $class, 'release-status' ) !== false;

        if ( ! $is_episode_label && ! $is_total_episode && ! $is_release_year && ! $is_release_status ) {
            return $block_content;
        }

        $post_id = get_the_ID();
        $runtime = get_post_meta( $post_id, 'episode_or_runtime', true );
        $release_year = trim( get_post_meta( $post_id, 'release_year', true ) );

        $is_numeric = preg_match( '/^\d+$/', $runtime );
        $is_movie_runtime = ( ! $is_numeric && $runtime !== '' );

        if ( $is_release_year && $release_year === '' ) {
            return '';
        }

        if ( $is_movie_runtime && $is_release_status ) {
            return '';
        }

        if ( $is_numeric ) {
            return $block_content;
        }
        
        if ( $is_episode_label ) {
            return '<p class="runtime-label has-large-font-size">Runtime</p>';
        }

        if ( $is_total_episode ) {
            return '<p class="runtime has-small-font-size">' . esc_html( $runtime ?: 'Unknown' ) . '</p>';
        }

        return $block_content;
    }
endif;
add_filter( 'render_block_core/paragraph', 'modify_paragraph_block_for_metadata', 10, 2 );