import { __ } from '@wordpress/i18n';
import { useBlockProps, InspectorControls } from '@wordpress/block-editor';
import { PanelBody, TextControl, TextareaControl } from '@wordpress/components';
import './editor.scss';

export default function Edit({ attributes, setAttributes }) {
	const { info, url, buttonText } = attributes;
	return (
		<>
			<div { ...useBlockProps() }>
				{ __( 'Telegram Card block.', 'telegram-card' ) }
			</div>
			
			<InspectorControls>
				<PanelBody title={ __( 'Telegram Card Settings' ) } initialOpen={true}>
					<TextareaControl
						label="Info Text"
						value={info}
						onChange={(value) => setAttributes({ info: value })}
					/>
					<TextControl
						label="Telegram URL"
						value={url}
						onChange={(value) => setAttributes({ url: value })}
					/>
					<TextControl
						label="Button Text"
						value={buttonText}
						onChange={(value) => setAttributes({ buttonText: value })}
					/>
				</PanelBody>
			</InspectorControls>
		</>
	);
}