<?php
global $post;

$heading_text    = isset( $attributes['headingText'] ) ? $attributes['headingText'] : 'You may also like';

$categories   = get_the_category( $post->ID );
$category_ids = array();

foreach ( $categories as $category ) {
    $category_ids[] = $category->term_id;
}

$args = array(
    'category__in'        => $category_ids,
    'post__not_in'        => array( $post->ID ),
    'posts_per_page'      => 10,
    'ignore_sticky_posts' => 1,
    'orderby'             => 'date',
);

$related_posts = new WP_Query( $args );

if ( $related_posts->have_posts() ) :
    ?>
    <div class="wp-block-related-posts">
        <h3 class="wp-block-heading custom-heading"><?php echo esc_html( $heading_text ); ?></h3>
        <ul class="related-posts">
            <?php
            while ( $related_posts->have_posts() ) :
                $related_posts->the_post();

                $release_year = get_post_meta( get_the_ID(), 'release_year', true );
				$episode_or_runtime = get_post_meta( get_the_ID(), 'episode_or_runtime', true );

                if ( ! empty( $episode_or_runtime ) ) {
                    $episode_or_runtime = trim( $episode_or_runtime );
                    if ( preg_match( '/^\d+$/', $episode_or_runtime ) ) {
                        $episode_or_runtime = sprintf( 'EP.%s', esc_html( $episode_or_runtime ) );
                    } else {
                        $episode_or_runtime = esc_html( $episode_or_runtime );
                    }
                }

				$has_meta = ! empty( $release_year ) || ! empty( $episode_or_runtime );
                ?>
                <li class="related-item">
                    <figure class="wp-block-post-featured-image">
                        <a href="<?php echo esc_url( get_permalink() ); ?>" target="_self">
                            <?php
                            if ( has_post_thumbnail() ) {
                                echo get_the_post_thumbnail(
                                    get_the_ID(),
                                    'large',
                                    array(
                                        'alt' => esc_attr( get_the_title() ? get_the_title() : 'No title' ),
                                    )
                                );
                            } else {
                                echo '<img src="' . esc_url( get_template_directory_uri() . '/assets/images/blank.gif' ) . '" alt="' . esc_attr( get_the_title() ? get_the_title() : 'No title' ) . '">';
                            }
                            ?>
                        </a>
                    </figure>
                    <div class="entry-header">
                        <h2 class="wp-block-post-title">
                            <a href="<?php echo esc_url( get_permalink() ); ?>" target="_self"><?php echo esc_html( get_the_title() ? get_the_title() : 'No title' ); ?></a>
                        </h2>
                        <?php if ( $has_meta ) : ?>
                            <div class="media-metadata-wrap">
                                <?php if ( ! empty( $release_year ) ) : ?>
                                    <span class="release-year"><?php echo esc_html( $release_year ); ?></span>
                                <?php endif; ?>
                                <?php if ( ! empty( $episode_or_runtime ) ) : ?>
                                    <span class="episode-or-runtime"><?php echo $episode_or_runtime; ?></span>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </li>
            <?php endwhile; ?>
        </ul>
    </div>
    <?php
    wp_reset_postdata();
endif;
?>