import { __ } from '@wordpress/i18n';
import { useBlockProps, InspectorControls } from '@wordpress/block-editor';
import { PanelBody, TextControl } from '@wordpress/components';
import './editor.scss';

export default function Edit({ attributes, setAttributes }) {
	const { headingText } = attributes;

	return (
		<>
			<div { ...useBlockProps() }>
				{ __( 'Related Posts block.', 'related-posts' ) }
			</div>

			<InspectorControls>
				<PanelBody title={__('Related Posts Setting', 'related-posts')} initialOpen={true}>
					<TextControl
						label={__('Heading Text', 'related-posts')}
						value={headingText}
						onChange={(value) => setAttributes({ headingText: value })}
					/>
				</PanelBody>
			</InspectorControls>
		</>
	);
}