import { RichText } from '@wordpress/block-editor';

export default function save({ attributes }) {
    const { heading, content } = attributes;

    return (
        <div className="wp-block-overview-section">
            <div className="overview-header">
                <RichText.Content
                    tagName="h2"
                    value={heading}
                    className="overview-title"
                />
                <span className="overview-icon"></span>
            </div>
            <RichText.Content
                tagName="p"
                value={content}
                className="overview-description"
            />
        </div>
    );
}