import { registerBlockType } from '@wordpress/blocks';
import './style.scss';
import Edit from './edit';
import save from './save';
import metadata from './block.json';

const blockIcon = (
	<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="-3 -3 24 24">
		<path fill="currentColor" d="M8.406 12.732L5.367 9.693q.815-1.435 2.375-2.838q2.012-1.812 7.1-6.126a1.795 1.795 0 0 1 2.53 2.53q-4.32 5.097-6.125 7.1q-1.402 1.555-2.841 2.373M3.99 11.146l2.965 2.964l-1.366 1.906l-5.276 1.795l1.771-5.3z" />
	</svg>
);
registerBlockType( metadata.name, {
	icon: blockIcon,
	/**
	 * @see ./edit.js
	 */
	edit: Edit,

	/**
	 * @see ./save.js
	 */
	save,
} );