import { __ } from '@wordpress/i18n';
import { useBlockProps, RichText } from '@wordpress/block-editor';
import './editor.scss';

export default function Edit({ attributes, setAttributes }) {
	const { heading, content } = attributes;

	return (
		<div { ...useBlockProps() }>
			<RichText
				tagName="h2"
				label={ __( 'Heading', 'overview-section' ) }
				value={ heading }
				onChange={ ( heading ) => setAttributes({ heading }) }
				placeholder={ __( 'Overview', 'overview-section' ) }
			/>
			<RichText
				tagName="p"
				label={ __( 'Content', 'overview-section' ) }
				value={ content }
				onChange={ ( content ) => setAttributes({ content }) }
				placeholder={ __( 'Enter your overview content here...', 'overview-section' ) }
			/>
		</div>
	);
}