<?php
$post_id         = get_the_ID();
$episode_number  = get_post_meta( $post_id, 'episode_or_runtime', true );
$release_status  = get_post_meta( $post_id, 'release_status', true );

if ( $episode_number && preg_match( '/^\d+$/', $episode_number ) ) {
    $display_status = $release_status ? $release_status : 'ongoing';

    if ( $display_status === 'upcoming' ) {
        return;
    }
    
    $post_title    = get_the_title( $post_id );
    $display_title = ! empty( $post_title ) ? esc_html( $post_title ) : 'No Title';

    $metadata_parts = array();

    $metadata_parts[] = sprintf( 'You are watching: <strong>%s</strong>', $display_title );
    $metadata_parts[] = sprintf( 'Episode: <strong>01-%s</strong>', esc_html( $episode_number ) );

    $status_class   = ( $display_status === 'completed' ) ? 'status-completed' : 'status-ongoing';
    $metadata_parts[] = sprintf( 'Status: <strong class="%s">%s</strong>', esc_attr( $status_class ), esc_html( $display_status ) );

    echo '<div class="wp-block-drama-info"><p>' . implode( ' • ', $metadata_parts ) . '</p></div>';
}