import { registerPlugin } from '@wordpress/plugins';
import { PluginDocumentSettingPanel } from '@wordpress/editor';
import { useSelect } from '@wordpress/data';
import { useEntityProp } from '@wordpress/core-data';
import { __experimentalVStack as VStack, __experimentalNumberControl as NumberControl, TextControl, SelectControl } from '@wordpress/components';

const PingeSettingPanel = () => {
	const postType = useSelect(
		(select) => select('core/editor').getCurrentPostType(),
		[]
	);

	if (postType !== 'post') {
		return null;
	};

	const [meta, setMeta] = useEntityProp('postType', postType, 'meta');
	const episodeOrRuntime = meta['episode_or_runtime'] || '';
	const releaseYear = meta['release_year'] || '';
	const releaseStatus = meta['release_status'] || '';
	const videoLanguageFormat = meta['video_language_format'] || '';

	const updateEpisodeOrRuntime = (newValue) => {
		setMeta({ ...meta, episode_or_runtime: newValue });
	};

	const updateReleaseYear = (newValue) => {
		setMeta({ ...meta, release_year: newValue });
	};

	const updateReleaseStatus = (newValue) => {
        setMeta({ ...meta, release_status: newValue });
    };

	const updateVideoLanguageFormat = (newValue) => {
		setMeta({ ...meta, video_language_format: newValue });
	};

	return (
		<PluginDocumentSettingPanel
			name="custom-label-panel"
			title="Custom Label Settings"
			className="custom-label-panel"
		>
			<VStack>
				<TextControl
					__nextHasNoMarginBottom
					__next40pxDefaultSize
					label="Episode Number or Video Runtime"
					type="text"
					value={episodeOrRuntime}
					onChange={updateEpisodeOrRuntime}
					help="For drama, enter the episode number (e.g., 10). For movie, enter the runtime (e.g., 2h 45m)."
				/>
				<NumberControl
					__next40pxDefaultSize
					label="Release Year"
					value={releaseYear}
					onChange={updateReleaseYear}
					placeholder="2026"
				/>
				<SelectControl
					__nextHasNoMarginBottom
					__next40pxDefaultSize
					label="Release Status"
					value={releaseStatus}
					options={[
						{ label: "Select Status", value: "" },
						{ label: "Ongoing", value: "ongoing" },
						{ label: "Completed", value: "completed" },
						{ label: "Upcoming", value: "upcoming" },
					]}
					onChange={updateReleaseStatus}
				/>
				<SelectControl
					__nextHasNoMarginBottom
					__next40pxDefaultSize
					label="Video Language Format"
					value={videoLanguageFormat}
					options={[
						{ label: "Select Language", value: "" },
						{ label: "Closed Caption ( CC )", value: "subtitle" },
						{ label: "និយាយខ្មែរ", value: "និយាយខ្មែរ" },
					]}
					onChange={updateVideoLanguageFormat}
				/>
			</VStack>
		</PluginDocumentSettingPanel>
	);
};

registerPlugin( 'pinge-document-setting-panel', {
	render: PingeSettingPanel,
} );