<?php
if ( ! is_single() || get_post_type() !== 'post' ) {
    return '';
}

$separator     = ' / ';
$home_link     = '<a href="' . esc_url( home_url() ) . '">Home</a>';
$category      = get_the_category();
$category_link = '';

if ( $category && isset( $category[0] ) ) {
    $cat_url      = esc_url( get_category_link( $category[0]->term_id ) );
    $cat_name     = esc_html( $category[0]->cat_name );
    $category_link = $separator . '<a href="' . $cat_url . '">' . $cat_name . '</a>';
}

$title      = esc_html( get_the_title() );
$breadcrumb = $home_link . $category_link . $separator . $title;
?>

<nav class="wp-block-breadcrumb" aria-label="Breadcrumb">
    <?php echo $breadcrumb; ?>
</nav>