<?php
$args = array(
	'post_type'           => 'post',
	'posts_per_page'      => 10,
	'post_status'         => 'publish',
	'ignore_sticky_posts' => 1,
);

$recent_posts = new WP_Query( $args );

if ( ! $recent_posts->have_posts() ) {
	return '';
}

$heading_text = isset( $attributes['headingText'] ) ? $attributes['headingText'] : 'Trending';
?>

<div class="blaze-slider blaze-post-slider">
	<div class="blaze-header">
		<h3 class="wp-block-heading custom-heading"><?php echo esc_html( $heading_text ); ?></h3>
		<div class="blaze-controls">
			<button class="blaze-prev" aria-label="Previous slide">
				<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="currentColor" d="M15.41 7.41L14 6l-6 6l6 6l1.41-1.41L10.83 12z"/></svg>
			</button>
			<button class="blaze-next" aria-label="Next slide">
				<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="currentColor" d="M10 6L8.59 7.41L13.17 12l-4.58 4.59L10 18l6-6z"/></svg>
			</button>
		</div>
	</div>
	<div class="blaze-container">
		<div class="blaze-track-container">
			<div class="blaze-track">
				<?php
				while ( $recent_posts->have_posts() ) :
					$recent_posts->the_post();

					$release_year = get_post_meta( get_the_ID(), 'release_year', true );
					$episode_or_runtime = get_post_meta( get_the_ID(), 'episode_or_runtime', true );

					if ( ! empty( $episode_or_runtime ) ) {
						$episode_or_runtime = trim( $episode_or_runtime );
						if ( preg_match( '/^\d+$/', $episode_or_runtime ) ) {
							$episode_or_runtime = sprintf( 'EP.%s', esc_html( $episode_or_runtime ) );
						} else {
							$episode_or_runtime = esc_html( $episode_or_runtime );
						}
					}

					$has_meta = ! empty( $release_year ) || ! empty( $episode_or_runtime );
					?>
					<div class="blaze-slide">
						<figure class="wp-block-post-featured-image">
							<a href="<?php echo esc_url( get_permalink() ); ?>" target="_self">
								<?php
								if ( has_post_thumbnail() ) {
									echo get_the_post_thumbnail(
										get_the_ID(),
										'large',
										array( 
											'alt' => esc_attr( get_the_title() ? get_the_title() : 'No title' ) 
										)
									);
								} else {
									echo '<img src="' . esc_url( get_template_directory_uri() . '/assets/images/blank.gif' ) . '" alt="' . esc_attr( get_the_title() ? get_the_title() : 'No title' ) . '">';
								}
								?>
							</a>
						</figure>
						<div class="entry-header">
							<h2 class="wp-block-post-title">
								<a href="<?php echo esc_url( get_permalink() ); ?>" target="_self"><?php echo esc_html( get_the_title() ? get_the_title() : 'No title' ); ?></a>
							</h2>
							<?php if ( $has_meta ) : ?>
								<div class="media-metadata-wrap">
									<?php if ( ! empty( $release_year ) ) : ?>
										<span class="release-year"><?php echo esc_html( $release_year ); ?></span>
									<?php endif; ?>
									<?php if ( ! empty( $episode_or_runtime ) ) : ?>
										<span class="episode-or-runtime"><?php echo $episode_or_runtime; ?></span>
									<?php endif; ?>
								</div>
							<?php endif; ?>
						</div>
					</div>
					<?php
				endwhile;
				wp_reset_postdata();
				?>
			</div>
		</div>
	</div>
</div>