import { __ } from '@wordpress/i18n';
import { useBlockProps, InspectorControls } from '@wordpress/block-editor';
import { PanelBody, TextControl } from '@wordpress/components';
import './editor.scss';

export default function Edit({ attributes, setAttributes }) {
	const { headingText } = attributes;

	return (
		<>
			<div { ...useBlockProps() }>
				{ __( 'Blaze Post Slider block.', 'blaze-post-slider' ) }
			</div>

			<InspectorControls>
				<PanelBody title={__('Slider Setting', 'blaze-post-slider')} initialOpen={true}>
					<TextControl
						label={__('Heading Text', 'blaze-post-slider')}
						value={headingText}
						onChange={(value) => setAttributes({ headingText: value })}
					/>
				</PanelBody>
			</InspectorControls>
		</>
	);
}