<?php
/**
 * Register Post Meta
 *
 * @package Pinge
 */
if ( ! function_exists( 'pinge_register_post_meta' ) ) :
    function pinge_register_post_meta() {
        register_post_meta( 'post', 'episode_or_runtime', array(
            'show_in_rest' => true,
            'single' => true,
            'type' => 'string',
            'auth_callback' => function() {
                return current_user_can('edit_posts');
            }
        ) );
        
        register_post_meta( 'post', 'release_year', array(
            'show_in_rest' => true,
            'single' => true,
            'type' => 'string',
            'auth_callback' => function() {
                return current_user_can('edit_posts');
            }
        ) );

        register_post_meta( 'post', 'release_status', array(
            'show_in_rest' => true,
            'single' => true,
            'type' => 'string',
            'auth_callback' => function() {
                return current_user_can('edit_posts');
            }
        ) );

        register_post_meta( 'post', 'video_language_format', array(
            'show_in_rest' => true,
            'single' => true,
            'type' => 'string',
            'auth_callback' => function() {
                return current_user_can('edit_posts');
            }
        ) );
    }
endif;
add_action( 'init', 'pinge_register_post_meta' );