<?php
/**
 * Plugin Initialization
 *
 * @package Pinge
 */
if ( ! function_exists( 'pinge_blocks_init' ) ) :
	function pinge_blocks_init() {
		$build_dir     = get_template_directory() . '/inc/build';
		$manifest_file = $build_dir . '/blocks-manifest.php';

		if ( function_exists( 'wp_register_block_types_from_metadata_collection' ) ) {
			wp_register_block_types_from_metadata_collection( $build_dir, $manifest_file );
			return;
		}

		if ( function_exists( 'wp_register_block_metadata_collection' ) ) {
			wp_register_block_metadata_collection( $build_dir, $manifest_file );
		}

		$manifest_data = require $manifest_file;
		foreach ( array_keys( $manifest_data ) as $block_type ) {
			register_block_type( $build_dir . "/{$block_type}" );
		}
	}
endif;
add_action( 'init', 'pinge_blocks_init' );

// Enqueue script for document setting panel
if ( ! function_exists( 'enqueue_plugin_document_setting_panel' ) ) :
	function enqueue_plugin_document_setting_panel() {
        if ( is_admin() ) {
            $script_path = '/inc/build/custom-label.js';
            wp_enqueue_script(
                'setting-panel-script',
                get_template_directory_uri() . $script_path,
                array(
                    'wp-plugins',
                    'wp-editor',
                    'wp-data',
                    'wp-core-data',
                    'wp-components',
                    'wp-element',
                ),
                filemtime( get_template_directory() . $script_path ),
                true
            );
        }
    }
endif;
add_action( 'enqueue_block_assets', 'enqueue_plugin_document_setting_panel' );