<?php
/**
 * Custom Labels
 *
 * @package Pinge
 */
if ( ! function_exists( 'pinge_custom_label' ) ) :
    function pinge_custom_label( $html, $post_id ) {
        $release_status = get_post_meta( $post_id, 'release_status', true );
        $video_language_format = get_post_meta( $post_id, 'video_language_format', true );
        $labels  = '';

        if ( ! empty( $release_status ) ) {
            $labels .= '<span class="release-status ' . esc_attr( $release_status ) . '">' . esc_html( $release_status ) . '</span>';
        };

        if ( ! empty( $video_language_format ) ) {
            if ( $video_language_format === 'subtitle' ) {
                $labels .= '<span class="cc-icon"></span>';
            } elseif ( $video_language_format === 'និយាយខ្មែរ' ) {
                $labels .= '<span class="khmer-dubbed">' . esc_html( $video_language_format ) . '</span>';
            }
        };
        
        return $html . $labels;
    }
endif;
add_filter( 'post_thumbnail_html', 'pinge_custom_label', 10, 2 );

// Format custom labels
if ( ! function_exists( 'format_custom_label' ) ) :
    function format_custom_label( $value, $name, $args ) {
        if ( $name !== 'core/post-meta' ) {
            return $value;
        }

        if ( isset( $args['key'] ) && $args['key'] === 'episode_or_runtime' && ! empty( $value ) ) {

            $value = trim( $value );

            if ( preg_match( '/^\d+$/', $value ) ) {
                return sprintf( 'EP.%s', esc_html( $value ) );
            }

            return esc_html( $value );
        }

        return $value;
    }
endif;
add_filter( 'block_bindings_source_value', 'format_custom_label', 10, 3 );