<?php
/**
 * Block Variations
 *
 * @package Pinge
 */
if ( ! function_exists( 'post_search_variation' ) ) :
    function post_search_variation( $variations, $block_type ) {
        if ( 'core/search' !== $block_type->name ) {
            return $variations;
        }

        $variations[] = array(
            'name'        => 'post-search',
            'title'       => 'Post Search',
            'attributes'  => array(
                'query' => array(
                    'post_type' => 'post',
                ),
            ),
        );

        return $variations;
    }
endif;
add_filter( 'get_block_type_variations', 'post_search_variation', 10, 2 );

// Heading
if ( ! function_exists( 'heading_variation' ) ) :
    function heading_variation( $variations, $block_type ) {
        if ( 'core/heading' !== $block_type->name ) {
            return $variations;
        }

        $variations[] = array(
            'name'        => 'custom-heading',
            'title'       => 'Custom Heading',
            'attributes'  => array(
                'level' => 3,
                'className' => 'custom-heading',
            ),
        );

        return $variations;
    }
endif;
add_filter( 'get_block_type_variations', 'heading_variation', 10, 2 );

// Release year
if ( ! function_exists( 'release_year_variation' ) ) :
    function release_year_variation( $variations, $block_type ) {
        if ( 'core/paragraph' !== $block_type->name ) {
            return $variations;
        }

        $variations[] = array(
            'name'        => 'release-year',
            'title'       => 'Release Year',
            'attributes'  => array(
                'className' => 'release-year',
                'metadata' => array(
                    'bindings' => array(
                        'content' => array(
                            'source' => 'core/post-meta',
                            'args'   => array(
                                'key' => 'release_year',
                            ),
                        ),
                    ),
                ),
            ),
        );

        return $variations;
    }
endif;
add_filter( 'get_block_type_variations', 'release_year_variation', 10, 2 );

// Episode or Runtime
if ( ! function_exists( 'episode_or_runtime_variation' ) ) :
    function episode_or_runtime_variation( $variations, $block_type ) {
        if ( 'core/paragraph' !== $block_type->name ) {
            return $variations;
        }

        $variations[] = array(
            'name'        => 'episode-or-runtime',
            'title'       => 'Episode or Runtime',
            'attributes'  => array(
                'className' => 'episode-or-runtime',
                'metadata' => array(
                    'bindings' => array(
                        'content' => array(
                            'source' => 'core/post-meta',
                            'args'   => array(
                                'key' => 'episode_or_runtime',
                            ),
                        ),
                    ),
                ),
            ),
        );

        return $variations;
    }
endif;
add_filter( 'get_block_type_variations', 'episode_or_runtime_variation', 10, 2 );