<?php
/*
 * Admin Settings
 *
 * @package Pinge
 */
if ( ! function_exists( 'pinge_admin_settings' ) ) :
    function pinge_admin_settings() {
        add_menu_page(
            'Pinge Settings',
            'Pinge',
            'manage_options',
            'pinge-settings',
            'pinge_settings_page',
            'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0Ij48cGF0aCBmaWxsPSJjdXJyZW50Q29sb3IiIGQ9Ik0xMiAxNS41QTMuNSAzLjUgMCAwIDEgOC41IDEyQTMuNSAzLjUgMCAwIDEgMTIgOC41YTMuNSAzLjUgMCAwIDEgMy41IDMuNWEzLjUgMy41IDAgMCAxLTMuNSAzLjVtNy40My0yLjUzYy4wNC0uMzIuMDctLjY0LjA3LS45N3MtLjAzLS42Ni0uMDctMWwyLjExLTEuNjNjLjE5LS4xNS4yNC0uNDIuMTItLjY0bC0yLTMuNDZjLS4xMi0uMjItLjM5LS4zMS0uNjEtLjIybC0yLjQ5IDFjLS41Mi0uMzktMS4wNi0uNzMtMS42OS0uOThsLS4zNy0yLjY1QS41MDYuNTA2IDAgMCAwIDE0IDJoLTRjLS4yNSAwLS40Ni4xOC0uNS40MmwtLjM3IDIuNjVjLS42My4yNS0xLjE3LjU5LTEuNjkuOThsLTIuNDktMWMtLjIyLS4wOS0uNDkgMC0uNjEuMjJsLTIgMy40NmMtLjEzLjIyLS4wNy40OS4xMi42NEw0LjU3IDExYy0uMDQuMzQtLjA3LjY3LS4wNyAxcy4wMy42NS4wNy45N2wtMi4xMSAxLjY2Yy0uMTkuMTUtLjI1LjQyLS4xMi42NGwyIDMuNDZjLjEyLjIyLjM5LjMuNjEuMjJsMi40OS0xLjAxYy41Mi40IDEuMDYuNzQgMS42OS45OWwuMzcgMi42NWMuMDQuMjQuMjUuNDIuNS40Mmg0Yy4yNSAwIC40Ni0uMTguNS0uNDJsLjM3LTIuNjVjLjYzLS4yNiAxLjE3LS41OSAxLjY5LS45OWwyLjQ5IDEuMDFjLjIyLjA4LjQ5IDAgLjYxLS4yMmwyLTMuNDZjLjEyLS4yMi4wNy0uNDktLjEyLS42NHoiLz48L3N2Zz4=',
            60
        );
    }
endif;
add_action( 'admin_menu', 'pinge_admin_settings' );

// Settings page
function pinge_settings_page() {
    ?>
    <div class="wrap">
        <h1>Pinge Settings</h1>

        <?php
        if ( isset( $_GET['settings-updated'] ) && $_GET['settings-updated'] ) {
            add_settings_error( 'pinge_messages', 'pinge_message', 'Settings Saved', 'updated' );
        }
        settings_errors( 'pinge_messages' );
        ?>

        <form method="post" action="options.php">
            <?php
            settings_fields( 'pinge_settings_group' );
            do_settings_sections( 'pinge-settings' );
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

// Register section and fields
function register_pinge_settings() {
    register_setting(
        'pinge_settings_group',
        'video_playlist_enabled',
        array(
            'sanitize_callback' => function( $input ) {
                return $input === '1' ? '1' : '';
            },
        )
    );

    register_setting(
        'pinge_settings_group',
        'video_playlist_license_key',
        array(
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    register_setting(
        'pinge_settings_group',
        'video_player_div_id',
        array(
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    register_setting(
        'pinge_settings_group',
        'blogger_ids',
        array(
            'sanitize_callback' => 'sanitize_blogger_ids',
        )
    );

    add_settings_section(
        'pinge_settings_section',
        null,
        null,
        'pinge-settings'
    );

    add_settings_field(
        'video_playlist_enabled',
        'Enable Video Playlist',
        'render_video_playlist_checkbox',
        'pinge-settings',
        'pinge_settings_section'
    );

    add_settings_field(
        'video_playlist_license_key',
        'Video Playlist License Key',
        'render_license_key_field',
        'pinge-settings',
        'pinge_settings_section'
    );

    add_settings_field(
        'video_player_div_id',
        'Player Container ID',
        'render_player_div_field',
        'pinge-settings',
        'pinge_settings_section'
    );

    add_settings_field(
        'blogger_ids',
        'API: Blogger ID(s)',
        'render_blogger_ids_field',
        'pinge-settings',
        'pinge_settings_section'
    );
}
add_action( 'admin_init', 'register_pinge_settings' );

// Render enable video playlist checkbox
function render_video_playlist_checkbox() {
    $is_enabled = get_option( 'video_playlist_enabled' ) ? 'checked' : '';
    ?>
    <input 
        type="checkbox" 
        name="video_playlist_enabled" 
        value="1" 
        <?php echo $is_enabled; ?>
    >
    <label for="video_playlist_enabled">Enable video playlist script.</label>
    <?php
}

// Render license key input field
function render_license_key_field() {
    $license_key = get_option( 'video_playlist_license_key' );
    ?>
    <input 
        type="text" 
        name="video_playlist_license_key" 
        value="<?php echo esc_attr( $license_key ); ?>" 
        class="regular-text" 
        placeholder="XXXXXXXXXXXXXXXXXXXX"
    >
    <p class="description">Enter your license key.</p>
    <?php
}

// Render player div ID input field
function render_player_div_field() {
    $player_div_id = get_option( 'video_player_div_id' );
    ?>
    <input 
        type="text" 
        name="video_player_div_id" 
        value="<?php echo esc_attr( $player_div_id ); ?>" 
        class="regular-text" 
        placeholder="abc-player"
    >
    <p class="description">This ID will be used to render the video player.</p>
    <?php
}

// Render blogger IDs textarea field
function render_blogger_ids_field() {
    $blogger_ids = get_option( 'blogger_ids' );
    ?>
    <textarea 
        name="blogger_ids" 
        rows="5" 
        cols="50" 
        class="large-text code" 
        placeholder="01234567890123456789"
    ><?php echo esc_textarea( $blogger_ids ); ?></textarea>
    <p class="description">Enter one Blogger ID per line.</p>
    <?php
}

// Sanitize blogger IDs
function sanitize_blogger_ids( $input ) {
    if ( empty( $input ) ) {
        return '';
    }

    $ids = explode( "\n", $input );
    $sanitized_ids = array();
    
    foreach ( $ids as $id ) {
        $clean_id = sanitize_text_field( trim( $id ) );
        if ( ! empty( $clean_id ) ) {
            $sanitized_ids[] = $clean_id;
        }
    }
    
    return implode( "\n", $sanitized_ids );
}