<?php
// Adds theme support for post formats
if ( ! function_exists( 'pinge_post_format_setup' ) ) :
	function pinge_post_format_setup() {
		add_theme_support( 'post-formats', array( 'aside', 'audio', 'chat', 'gallery', 'image', 'link', 'quote', 'status', 'video' ) );
	}
endif;
add_action( 'after_setup_theme', 'pinge_post_format_setup' );

// Enqueues editor-style.css in the editors
if ( ! function_exists( 'pinge_editor_style' ) ) :
	function pinge_editor_style() {
		add_editor_style( get_parent_theme_file_uri( 'assets/css/editor-style.css' ) );
	}
endif;
add_action( 'after_setup_theme', 'pinge_editor_style' );

// Enqueues CSS
if ( ! function_exists( 'pinge_enqueue_styles' ) ) :
	function pinge_enqueue_styles() {
		wp_enqueue_style(
			'pinge',
			get_parent_theme_file_uri( 'style.css' ),
			array(),
			wp_get_theme()->get( 'Version' )
		);
		if ( is_singular() && get_option( 'video_playlist_enabled' ) === '1' ) {
			wp_enqueue_style(
				'playlist',
				get_template_directory_uri() . '/assets/css/playlist.min.css',
				array(),
				null
			);
		}
	}
endif;
add_action( 'wp_enqueue_scripts', 'pinge_enqueue_styles' );

// Enqueues JS
if ( ! function_exists( 'pinge_enqueue_scripts' ) ) :
	function pinge_enqueue_scripts() {
		if ( is_home() && ! is_paged() ) {
			wp_enqueue_script(
                'blaze-slider',
                get_template_directory_uri() . '/assets/js/blaze-slider.min.js',
                array(),
                '1.9.3',
                true
            );
		};
		wp_enqueue_script(
			'pinge',
			get_template_directory_uri() . '/assets/js/main.min.js',
			array(),
			wp_get_theme()->get( 'Version' ),
			true
		);
		if ( is_singular() && get_option( 'video_playlist_enabled' ) === '1' ) {
            wp_enqueue_script(
                'crypto',
                get_template_directory_uri() . '/assets/js/crypto-js.min.js',
                array(),
                '4.2.0',
                true
            );
            wp_enqueue_script(
				'jwplayer',
				'https://content.jwplatform.com/libraries/IDzF9Zmk.js',
				array(),
				null,
				true
            );
			wp_enqueue_script(
                'playlist',
                get_template_directory_uri() . '/assets/js/playlist.min.js',
                array(),
                null,
                true
            );
			$video_player_settings = [
				'license' => get_option( 'video_playlist_license_key' ),
				'playerContainer' => get_option( 'video_player_div_id' ),
				'playlistLayoutHorizontal' => false,
				'playlistReload' => true,
				'jwplayerCustomIcon' => true,
				'jwplayerLogo' => '',
				'scrollIntoView' => [
					'enable' => true,
					'stickyHeaderSelector' => '.site-header',
					'offset' => 24,
				],
				'bloggerAPI' => [
					'blogId' => array_filter(explode("\n", get_option('blogger_ids', ''))),
				],
				'bunnyStreamAPI' => [
					'apiKey' => [],
					'libraryId' => [],
					'pullZoneUrl' => [],
				],
				'bannerAd' => [
					'image' => '',
					'link' => '',
				],
				'videoAd' => [
					'show' => false,
					'countdown' => 5,
					'data' => [
						[
							'source' => '',
							'clickUrl' => '',
						],
					],
				],
				'translations' => [
					'countdownExpired' => '',
					'videoLoadingMessage' => '',
					'seconds' => '',
					'skipAdIn' => '',
					'skip' => '',
					'prev' => '',
					'next' => '',
					'goDown' => '',
					'goUp' => '',
				],
			];
			$player_options = 'const videoPlayerSettings = ' . wp_json_encode($video_player_settings, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE ) . ';';
			wp_add_inline_script( 'playlist', $player_options, 'before' );
		}
	}
endif;
add_action( 'wp_enqueue_scripts', 'pinge_enqueue_scripts' );

// Initialization
require_once get_template_directory() . '/inc/theme-init.php';

// Register sidebar template part
function sidebar_template_part( array $areas ) {
	$areas[] = array(
		'area'        => 'sidebar',
		'area_tag'    => 'aside',
		'label'       => 'Sidebar',
		'description' => 'The Sidebar template defines a page area that typically contains widgets and other content.',
		'icon'        => 'sidebar',
	);

	return $areas;
}
add_filter( 'default_wp_template_part_areas', 'sidebar_template_part' );